# Installation Guide - Coco Ops Forecast & Staffing Recommender

## Prerequisites

Before installing, ensure you have:

- ✅ WordPress 5.8 or higher
- ✅ PHP 7.4 or higher
- ✅ **The Events Calendar** plugin (active)
- ✅ **Event Tickets Plus** plugin (active)
- ✅ **WooCommerce** plugin (active)
- ✅ Database write permissions
- ✅ Cron jobs enabled on server

## Installation Steps

### Step 1: Upload Plugin

1. Download the `coco-ops-forecast` folder
2. Upload to your WordPress installation:
   ```
   /wp-content/plugins/coco-ops-forecast/
   ```
3. Ensure all files are present:
   - `coco-ops-forecast.php` (main file)
   - `includes/` (6 PHP class files)
   - `assets/` (CSS and JS files)
   - `templates/admin-pages/` (5 PHP template files)
   - `README.md` and `INSTALL.md`

### Step 2: Activate Plugin

1. Log in to WordPress admin
2. Navigate to **Plugins → Installed Plugins**
3. Find "Coco Ops Forecast & Staffing Recommender"
4. Click **Activate**

### Step 3: Verify Installation

After activation, the plugin will automatically:
- ✅ Create 6 database tables (wp_coco_*)
- ✅ Insert default YAML ruleset (v1.0.0)
- ✅ Schedule twice-daily cron job for snapshots
- ✅ Grant capabilities to administrators

### Step 4: Access Plugin

1. Look for **Ops Forecast** in the WordPress admin menu (left sidebar)
2. You should see a chart icon and 5 submenu items:
   - Events
   - Forecast Dashboard
   - Rules
   - Settings
   - About

### Step 5: Initial Configuration

#### A. Configure Settings

1. Go to **Ops Forecast → Settings**
2. Add your venues:
   - Click "Add Venue"
   - Enter venue name (e.g., "Twnty7")
   - Enter slug (e.g., "twnty7")
   - Set capacity (e.g., 600)
   - Choose default timeband
3. Review snapshot schedule (default: 10:00 and 18:00)
4. Set cohort matching sensitivity (recommend: "medium")
5. Click **Save Settings**

#### B. Review Rules

1. Go to **Ops Forecast → Rules**
2. Review the default ruleset (v1.0.0)
3. Adjust ratios if needed for your venues
4. Default ratios:
   - Security: 1 per 75 guests
   - Bartenders: 1 per 40 guests
   - Bottle Girls: 1 per 100 guests
   - Wait Staff: 1 per 60 guests
   - Managers: 1 per 200 guests

## Getting Started

### Phase 1: Build Historical Dataset (Week 1-2)

1. Go to **Ops Forecast → Events**
2. For each PAST event (last 4-6 weeks):
   - Click **Actuals** button
   - Enter final attendance (required)
   - Enter final revenue (optional but recommended)
   - Enter actual staff used for each role
   - Add notes about what worked well
   - Click **Save Actuals**
3. Target: At least 3-5 events per venue to start

### Phase 2: Start Planning (Week 3+)

1. For upcoming events, click **Plan** button
2. Use **Manual Mode** initially:
   - Enter expected attendance
   - Click **Compute Staffing**
   - Review recommendations and rationale
   - Click **Save Plan**
3. Let snapshots run automatically (twice daily)

### Phase 3: Monitor Forecasts (Week 5+)

1. Go to **Ops Forecast → Forecast Dashboard**
2. Select an upcoming event
3. Review:
   - Current ticket/table sales
   - Cohort forecast (p50 prediction)
   - Pacing vs historical median
   - Confidence level
4. Once confidence is "medium" or "high", switch to **Auto Mode**

### Phase 4: Continuous Improvement (Ongoing)

1. Always enter actuals after events
2. Review forecast accuracy monthly
3. Adjust YAML rules if needed
4. System learns and improves automatically

## Verification Checklist

After installation, verify these work:

- [ ] Can access Ops Forecast menu
- [ ] Events page loads and shows upcoming events from The Events Calendar
- [ ] Can open Planning modal and compute staffing
- [ ] Can save actuals for a past event
- [ ] Settings page allows adding venues
- [ ] Rules page shows default YAML ruleset v1.0.0
- [ ] Forecast Dashboard loads (may show "no forecast" until data collected)
- [ ] Snapshots run (check in a few hours, or manually trigger in Settings)

## Troubleshooting

### Plugin doesn't appear in menu

**Solution**: Check user has administrator role with `coco_ops_view` capability

### Database tables not created

**Solution**: 
1. Deactivate plugin
2. Check database user has CREATE TABLE permission
3. Reactivate plugin
4. Check error logs

### No events showing

**Solution**:
1. Verify The Events Calendar is active
2. Create a test event with future start date
3. Ensure event is published (not draft)
4. Check event has `_EventStartDate` meta field

### Snapshots not running

**Solution**:
1. Verify WordPress cron is working: `wp cron event list`
2. Manually trigger: Settings → Maintenance → Run Snapshots Now
3. Check for cron hook: `coco_ops_snapshot_cron`
4. If using server cron instead of WP cron, add to crontab:
   ```
   0 10,18 * * * cd /path/to/wordpress && wp cron event run coco_ops_snapshot_cron
   ```

### Forecast shows "fallback" method

**Solution**: This is normal - need more historical data
- Enter actuals for 3+ similar past events
- Wait for snapshots to collect data over time
- System will automatically switch to cohort forecasting

### YAML validation errors

**Solution**:
1. Check indentation (use spaces, not tabs)
2. Ensure all required roles are present
3. Verify all numeric values are valid
4. Copy structure from default ruleset if needed

## Database Tables Reference

Created tables (with `wp_` prefix):

| Table | Purpose | Size Estimate |
|-------|---------|---------------|
| `coco_event_features` | Event metadata | ~1KB per event |
| `coco_event_snapshots` | Sales tracking | ~0.5KB per snapshot |
| `coco_event_planning` | Manual estimates | ~0.3KB per event |
| `coco_staffing_recs` | Recommendations | ~1KB per rec |
| `coco_event_actuals` | Post-event data | ~0.5KB per event |
| `coco_rulesets` | YAML rules | ~2KB per version |

Expected growth: ~50-100MB per year for active venues with 200+ events/year

## Uninstallation

To cleanly remove the plugin:

1. Deactivate plugin in WordPress admin
2. To remove data (optional):
   ```sql
   DROP TABLE wp_coco_event_features;
   DROP TABLE wp_coco_event_snapshots;
   DROP TABLE wp_coco_event_planning;
   DROP TABLE wp_coco_staffing_recs;
   DROP TABLE wp_coco_event_actuals;
   DROP TABLE wp_coco_rulesets;
   DELETE FROM wp_options WHERE option_name = 'coco_ops_settings';
   ```
3. Delete plugin folder: `/wp-content/plugins/coco-ops-forecast/`

## Support

**Questions or issues?**

- 📧 Email: tech@cococure.co.uk
- 📚 Documentation: See README.md
- 🐛 Bug reports: Provide WordPress version, PHP version, and error logs

## Next Steps

Once installed:

1. ✅ Read the README.md for full feature documentation
2. ✅ Watch the dashboard populate with snapshot data
3. ✅ Enter historical actuals to build forecasting intelligence
4. ✅ Review the About page for workflow recommendations

**Happy forecasting! 🎯**

