# Events Loading Fixed

## ✅ Issues Identified and Fixed

### 1. **Venue Loading in Events** ✅
**Problem:** Events were trying to get venue from taxonomy instead of post meta
**Fix:** Now uses `get_post_meta($event_id, '_EventVenueID', true)` to get venue ID

### 2. **Column Name Mismatches** ✅
**Problem:** Code was using wrong column names from database tables
**Fix:** Updated to match actual database schema:

- **Staffing table**: `rec_bartenders`, `rec_security`, etc. (not `bartenders`, `security`)
- **Planning table**: Removed non-existent `use_forecast` column
- **Snapshot table**: `revenue_snapshot` (not `revenue_to_date`), removed non-existent forecast columns

### 3. **Event Processing Logic** ✅
**Problem:** Debug response was sent even when events existed
**Fix:** Now processes all events first, then only shows debug if truly empty

## 🔧 What Changed

### REST API Endpoint (`includes/class-rest-api.php`)

**Venue Loading:**
```php
// OLD (wrong - using taxonomy)
$venue_terms = wp_get_post_terms($event_id, 'tribe_events_venue');

// NEW (correct - using post meta)
$venue_id = get_post_meta($event_id, '_EventVenueID', true);
$venue_post = get_post($venue_id);
$venue_name = $venue_post->post_title;
```

**Column Names:**
```php
// Staffing - now uses correct column names
'bartenders' => $staffing->rec_bartenders ?? 0,
'security' => $staffing->rec_security ?? 0,
// etc.

// Planning - removed non-existent use_forecast
'est_attendance' => $planning->est_attendance ?? 0,
'est_tables' => $planning->est_tables ?? 0,

// Snapshot - correct column name
'revenue_snapshot' => $snapshot->revenue_snapshot ?? 0,
```

## 🚀 What Should Work Now

### ✅ Events Page
- Should display your 839 events
- Each event shows:
  - Event title
  - Start date
  - Venue name (from `_EventVenueID` meta)
  - Capacity
  - Planning status
  - Staffing recommendations
  - Actuals status

### ✅ Venue Filtering
- Dropdown shows your 4 venues
- Filtering by venue works correctly
- Uses proper venue IDs

### ✅ Forecast Dashboard
- Event selector populated with events
- Each event shows venue name
- Forecast data loads correctly

## 📋 Test Checklist

### 1. Test Events API
Visit: `/wp-json/coco-ops/v1/events`

Should return array of events with:
```json
[
  {
    "id": 123,
    "title": "Event Name",
    "start_date": "2025-01-01 20:00:00",
    "venue_id": 19014,
    "venue_name": "Haus Stratford",
    "capacity": 500,
    "planning": null,
    "staffing": null,
    "actuals": null
  }
]
```

### 2. Test Events Page
Go to: **Ops Forecast → Events**
- Should show table of events
- Venue column shows correct venue names
- Filtering works

### 3. Test Forecast Dashboard
Go to: **Ops Forecast → Forecast**
- Event dropdown shows your events
- Selecting event shows details
- Venue name displays correctly

## 🔍 If Still Empty

### Check API Directly
1. Visit `/wp-json/coco-ops/v1/events` in your browser
2. Look for:
   - If you see `"events": []` with `"debug": {...}` → Check the debug info
   - If you see an array of events → Frontend JavaScript issue
   - If you see an error → Backend/permissions issue

### Check Browser Console
Press F12 → Console tab:
- Look for JavaScript errors
- Check what `API.getEvents()` returns
- Verify Alpine.js is loading

### Check Database
Your events should have:
- `post_type = 'tribe_events'`
- `post_status = 'publish'`
- `_EventVenueID` meta with valid venue ID
- `_EventStartDate` meta with date

## Expected Results

With 839 events and 4 venues, you should see:
- ✅ Events table with up to 100 events (pagination)
- ✅ Correct venue names for each event
- ✅ Working venue filter dropdown
- ✅ "Plan" and "Actuals" buttons for each event
- ✅ Event selector in Forecast dashboard

The database column mismatches have been fixed and venue loading now uses the correct method! 🎯
