# Step-by-Step Debugging Guide

## I've Added Debug Logging

The JavaScript now logs everything to the browser console. This will tell us exactly what's happening.

## Step 1: Reload the Plugin Page

1. **Go to Ops Forecast → Events**
2. **Open Browser Console** (Press F12)
3. **Look for these logs:**

You should see:
```
🔍 API Request: {url: "...", nonce: "...", credentials: "same-origin", currentUser: {...}}
📡 API Response: {url: "...", status: 200, ok: true, data: [...]}
```

**If you see `❌ API Error` or `status: 401`**, continue to Step 2.

## Step 2: Check What the Console Shows

### Scenario A: If you see "credentials: same-origin" ✅
The fix is loaded! If still getting 401, it's a server-side permission issue.

### Scenario B: If you DON'T see "credentials: same-origin" ❌
The browser is still using cached JavaScript. Try:
1. Hard refresh: `Ctrl+Shift+R` or `Cmd+Shift+R`
2. Clear browser cache completely
3. Try incognito/private browsing mode

### Scenario C: If you see "cocoOpsData is not defined" ❌
The script isn't loading properly. Check if you're on the right admin page.

## Step 3: Check Current User Data

In the console logs, look for `currentUser`:
```javascript
currentUser: {
    id: 1,
    canManageOptions: true,
    canEditPosts: true
}
```

- If `id: 0` → You're not logged in
- If `canManageOptions: false` → Your account isn't an administrator
- If `canManageOptions: true` but still 401 → Server-side permission issue

## Step 4: Run the Debug Script

Visit:
```
https://your-site.com/wp-content/plugins/coco-ops-forecast/debug-auth.php
```

This will show:
- ✅ User ID and login status
- ✅ What capabilities you have
- ✅ If REST API works when called directly from PHP
- ✅ Specific error messages

## Step 5: Test API Directly in Browser

Open these URLs in a new browser tab (while logged in):
- `/wp-json/coco-ops/v1/events`
- `/wp-json/coco-ops/v1/venues`

### If these work in browser but not in JavaScript:
→ It's a fetch/cookie issue
→ Make sure you're testing on the same domain

### If these also return 401 in browser:
→ It's a server-side permission issue
→ Need to fix PHP permission callbacks

## What to Tell Me

After following these steps, tell me:

1. **What the console shows:**
   - Do you see the 🔍 API Request logs?
   - What's the `status` in the response?
   - What's in `currentUser`?

2. **What the debug script shows:**
   - Is logged in: Yes/No?
   - Is admin: Yes/No?
   - Events endpoint response: Success/Error?

3. **What happens when you open API URLs in browser:**
   - Do they return JSON data or 401 error?

## Quick Checklist

- [ ] Opened browser console (F12)
- [ ] Went to Ops Forecast → Events page
- [ ] Looked for 🔍 API Request logs
- [ ] Checked if credentials: "same-origin" is shown
- [ ] Ran debug-auth.php script
- [ ] Tested API URLs directly in browser

## Common Issues & Fixes

### Issue: JavaScript is cached
**Fix:** Hard refresh or clear cache

### Issue: Not logged in
**Fix:** Log in to WordPress admin first

### Issue: Not an administrator
**Fix:** Make sure you're logged in as admin role

### Issue: Nonce is empty/undefined
**Fix:** Check if cocoOpsData is being loaded correctly

### Issue: 401 even with credentials
**Fix:** Server-side permission callback needs adjustment

With the debug logging, we'll be able to see exactly where it's failing! 🎯
